// --------------------------------- lsw_defintions.h -------------------------------------------
//
//  Include file for Linux LabBrick rf switch defintions
//
// (c) 2021-2025 by Vaunix Technology Corporation, all rights reserved
//
//  NB  Version 1.0.1 LSW Ethernet Socket Device Driver
//-----------------------------------------------------------------------------
#ifndef __LSWSOCKET_H__
#define __LSWSOCKET_H__

/// ---------- Include headers ----------------
#include "lswdrvr.h"

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif
/// ---------- Macros ----------------

// HID Datablock size
#define HR_BLOCKSIZE 6          // size of the block of bytes buffer in our HID report

// HID Command Message Length
#define HID_REPORT_LENGTH 8         // use an 8 byte report..

// LSW command message ID to send to the device
#define VNX_GET         0x00    // the set and get bits are or'd into the msb of the command byte
#define VNX_SET         0x80

#define VNX_SAVEPAR     0x0C    // command to save user parameters to flash, data bytes must be
                                // set to 0x42, 0x55, 0x31 as a key to enable the flash update
                                // all of the above settings are saved (RF Mute State, Attenuation,
                                // sweep parameters, etc.
#define VNX_GETSERNUM   0x1F    // get the serial number, value is a DWORD

#define VNX_MODELNAME   0x22    // get (no set allowed) the device's model name string -- last 6 chars only

#define VNX_DEFAULTS    0x0F    // restore all settings to factory default

// ---------------------- LDA system Specific Commands ---------------------
#define VNX_SWVERSION      0x60     // SW Version
#define VNX_IPMODE         0x61     // IP interface mode Static/DHCP
#define VNX_IPADDR         0x62     // IP Address
#define VNX_IPMASK         0x63     // Subnet Mask
#define VNX_IPGW           0x64     // Gateway

#define VNX_SWSELECT		0x54	// Set/Get Switch port Selection
#define VNX_MAXPORTS        0x56    // Report the maxports of the device
#define VNX_SWEXTMOD		0x58	// Switch trigger mode selection
// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_PORTS  4          // Max ports on each rf switch devices

// ----------- Data Types ----------------
#define DEVID unsigned int

// Device IP length (IPV4)
#define DEVICE_IPV4_LENGTH 16
#define RXBUFF_DATA_LENGTH 24
#define TXBUFF_CMD_LENGTH   8

// ----------- Command Equates -----------

#define BYTE unsigned char

// Response Data Message Datastructure
typedef struct
{
  char command;
  char length;
  char data[HR_BLOCKSIZE];
} RESPONSE_DATA_T;

// LDA Device data Structure
typedef struct
{
  //  Global device variables

  int DevType;
  int SerialNumber;
  char ModelName[MAX_MODELNAME];
  char Swversion[MAX_SWVERSION];
  int  ipmode;
  char ipaddress[MAX_NETBUFF];
  char netmask[MAX_NETBUFF];
  char gateway[MAX_NETBUFF];
  //  Per Switch variables
  volatile int Maxswports;
  volatile int rfswitchoutput[MAX_SWDEVICES];
  int NumSwitches;
  // Internal variables used to identify and manage the hardware
  char deviceip[DEVICE_IPV4_LENGTH];
  char sndbuff[TXBUFF_CMD_LENGTH];
  char rcvbuff[RXBUFF_DATA_LENGTH];
  int  devicesockfd;
  int  deviceready; // Set the device ready flag 
  int  responseready; // Response ready flag
} LSWPARAMS;

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif // __LSWSOCKET_H__